/**
* @file
* Behaviors for the THEME_NAME theme.
*/
(function($, _, Drupal, drupalSettings) {
'use strict';

 Drupal.behaviors.Counter = {
    attach: function (context) {
      $(window).scroll(startCounter);
      function startCounter() {
       if ($("body").hasClass("path-frontpage")) {
        if ($(window).scrollTop() >= $('.paragraph--type-gat-in-numbers').offset().top - 92) {
          $(window).off("scroll", startCounter);
          $('.paragraph--type-gat-in-numbers .field .field--item ', context).each(function () {
            var $this = $(this);
            jQuery({Counter: 0}).animate({Counter: $this.text()}, {
              duration: 10000,
              easing: 'swing',
              step: function (now) {
                $this.text(Math.ceil(now).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
              }
            });
          });
        }
      }
    }
  }
};

Drupal.behaviors.MatchHeight = {
  attach: function(context) {
    $('.contact').matchHeight();
    $('.careers-section').matchHeight();
    $('.paragraph--type-inclusion .inclusion-wrapper').matchHeight();
    $('.paragraph--type-gat-in-numbers .field:not(.field--name-bp-modal-title)').matchHeight();
  }
};

Drupal.behaviors.AccordionClose = {
  attach: function(context) {
    $('.accoridion .panel-title a').click(function(){
      $('.panel-collapse.in')
      .collapse('hide');
    });
  }
};

Drupal.behaviors.BackgroundHeight = {
  attach: function(context) {
    $(window).on("orientationchange resize load", function() {
      $(document).ready(function() {
        var height_content_wrapper = $('.node--view-mode-banner-image .background-wrapper .content-wrapper').height();
        $('.node--type-landing-page.node--view-mode-banner-image .background-wrapper').height(height_content_wrapper);
      });
    });
  }
};

Drupal.behaviors.ChangeClass = {
  attach: function(context) {
    $.ajax({
      success: function(data) { //success!
        var ticket_type = $('.form-item-ticket-type select').attr('id');
        if (ticket_type != undefined) {
          var ticket_type_id = '#' + ticket_type;
        }
        var personal_info = $('.personal-info').attr('id');
        if (personal_info != undefined) {
          var personal_info_id = '#' + personal_info;
        }
        var ticket_type_id = $(ticket_type_id).val();

        callback(ticket_type_id, personal_info_id);
      },
      error: function(data) { //error
        console.log("error: " + data);
      }
    });

    function callback(response, response2) {
      var type = response;
      var personal_info = response2;
      if (type == 15 || type == 18) {
        $(personal_info).addClass("active");
      } else {
        $(personal_info).removeClass("active");
      }
    }

    $(document).on('change', '.form-item-ticket-type select', function() {
      var ticket_type = this.value;
      if (ticket_type == 15 || ticket_type == 18) {
        $(".personal-info").addClass("active");
      } else {
        $(".personal-info").removeClass("active");
      }
    });
  }
};

Drupal.behaviors.Newsletter = {
  attach: function (context) {
      AOS.init();
      $(".path-frontpage").addClass("overflow-hidden");
    $(document).on('click', '.spb_close ', function (e) {
      $('.block-webform-7-modal').hide();
      $(".path-frontpage").removeClass("overflow-hidden");
    });
    document.onkeydown = function (e) {
      if(e.which == 27){
        $('.block-webform-7-modal').hide();
        $(".path-frontpage").removeClass("overflow-hidden");
      }
    }
  }
};

Drupal.behaviors.ChangeValue = {
  attach: function(context) {
   // going_to
    $('#yourElement').addClass('animate__animated animate__bounceOutLeft');

   $(document).on('change', '.form-item-going-to select', function() {
     $(".form-item-leaving-from-2nd select").val(this.value);
   });
   
   var going_to_value = $('.form-item-going-to select').val();
   $(".form-item-leaving-from-2nd select").val(going_to_value);

  // going_to_2nd
  $(document).on('change', '.form-item-going-to-2nd select', function() {
    $(".form-item-leaving-from-3rd select").val(this.value);
  });

  var going_to_value_2nd = $('.form-item-going-to-2nd select').val();
  $(".form-item-leaving-from-3rd select").val(going_to_value_2nd);
 }
};

})(window.jQuery, window._, window.Drupal, window.drupalSettings);