<?php

namespace Drupal\gat_tweaks\Plugin\WebformHandler;

use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Plugin\WebformHandlerBase;
use Drupal\Component\Utility\Html;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Webform validate handler.
 *
 * @WebformHandler(
 *   id = "gat_tweaks_custom_validator_countries",
 *   label = @Translation("Countries validate"),
 *   category = @Translation("Settings"),
 *   description = @Translation("Countries validate"),
 *   cardinality = \Drupal\webform\Plugin\WebformHandlerInterface::CARDINALITY_SINGLE,
 *   results = \Drupal\webform\Plugin\WebformHandlerInterface::RESULTS_PROCESSED,
 *   submission = \Drupal\webform\Plugin\WebformHandlerInterface::SUBMISSION_OPTIONAL,
 * )
 */
class CustomizeHolidayWebformHandler extends WebformHandlerBase {

	use StringTranslationTrait;

  public function validateForm(array &$form, FormStateInterface $form_state, WebformSubmissionInterface $webform_submission) {
  	$this->validateCountries($form_state);
    $this->validateDate($form_state);
  }

  /**
   * Validate Countries.
   */
  private function validateCountries(FormStateInterface $formState) {
    $leaving_from = $formState->getValue('leaving_from');
    $going_to  = $formState->getValue('going_to');
    $leaving_from_2nd = $formState->getValue('leaving_from_2nd');
    $going_to_2nd  = $formState->getValue('going_to_2nd');
    $leaving_from_3rd = $formState->getValue('leaving_from_3rd');
    $going_to_3rd  = $formState->getValue('going_to_3rd');
    $ticket_type =   $formState->getValue('ticket_type');

    if ($leaving_from == $going_to) {
      $formState->setErrorByName('going_to', $this->t('"Going to" Field Should be Different Leaving From Field.'));
    }

    // 2nd
    if (!empty($leaving_from_2nd) && !empty($going_to_2nd)) {
     if ($leaving_from_2nd == $going_to_2nd) {
      $formState->setErrorByName('going_to_2nd', $this->t('"Going to 2nd destination" Field Should be Different Leaving From 1st destination Field.'));
    }
  }
    // 3rd
   if (!empty($leaving_from_3rd) && !empty($going_to_3rd)) {
    if ($leaving_from_3rd == $going_to_3rd) {
     $formState->setErrorByName('going_to_3rd', $this->t('"Going to 3rd destination" Field Should be Different Leaving From 2nd destination Field.'));
   }
 }
}

  /**
   * Validate date.
   */
  private function validateDate(FormStateInterface $formState) {
    $current_date = date('Y-m-d');
    $departing_date = $formState->getValue('departing_date');
    $departing_date_2nd = $formState->getValue('departing_date_2nd');
    $departing_date_3rd = $formState->getValue('departing_date_3rd');
    $returning_date = $formState->getValue('returning_date');
    
    if ($departing_date < $current_date) {
    $formState->setErrorByName('departing_date', $this->t('"Departing Date" Should be Greater than or Equal Current Date.'));
    }

    if (!empty($returning_date)) {
     if ($returning_date <= $departing_date) {
      $formState->setErrorByName('returning_date', $this->t(' "Returning Date" Should Be Greater than Departing Date.'));
    }
    if ($returning_date <= $departing_date_2nd) {
      $formState->setErrorByName('returning_date', $this->t(' "Returning Date" Should Be Greater than Departing Date 2nd destination.'));
    }
    if ($returning_date <= $departing_date_3rd) {
      $formState->setErrorByName('returning_date', $this->t(' "Returning Date" Should Be Greater than Departing Date 3rd destination.'));
    }
  }
  
   // 2nd 
  $departing_date_2nd = $formState->getValue('departing_date_2nd');
  if (!empty($departing_date_2nd)) {
   if ($departing_date_2nd <= $departing_date) {
    $formState->setErrorByName('departing_date_2nd', $this->t('"Departing date 2nd" Should Be Greater than Departing Date destination.'));
   }
 }
  // 3rd 
  $departing_date_3rd = $formState->getValue('departing_date_3rd');
  if (!empty($departing_date_3rd)) {
    if ($departing_date_3rd < $departing_date_2nd) {
      $formState->setErrorByName('departing_date_3rd', $this->t('"Departing date 3rd" Should Be Greater than Departing date 2nd destination.'));
    }
  }
 }
}