<?php

namespace Drupal\gat_tweaks\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Block\BlockPluginInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\Core\Link;

/**
 * Provides a 'GAT Tweaks Copy Rights'.
 *
 * @Block(
 * id = "gat_tweaks_copy_rights",
 * admin_label = @Translation("GAT Tweaks Copy Rights"),
 * category = @Translation("GAT")
 * )
 */
class GatTweaksCopyRights extends BlockBase implements BlockPluginInterface {

  /**
   *
   * {@inheritdoc}
   */
  public function build() {
    $link = Link::fromTextAndUrl(t('Complete Chain'), Url::fromUri('https://www.completechaintech.com', array('attributes' => array('target' => '_blank'))))->toString();
    $block_body = 'Developed by &nbsp;@link. All rights reserved,  © @year';
    return [
      '#type' => 'markup',
      '#markup' => t($block_body, array('@year' => date('Y'),'@link'=>$link)),
    ];
  }

  /**
   *
   * {@inheritdoc}
   */
  public function blockForm($form, FormStateInterface $form_state) {
    $form = parent::blockForm($form, $form_state);
    return $form;
  }

  /**
   *
   * {@inheritdoc}
   */
  public function blockSubmit($form, FormStateInterface $form_state) {
    parent::blockSubmit($form, $form_state);
  }

}
