<?php
// @codingStandardsIgnoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 8.0 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->insert('node')
  ->fields([
    'nid',
    'vid',
    'type',
    'language',
    'title',
    'uid',
    'status',
    'created',
    'changed',
    'comment',
    'promote',
    'moderate',
    'sticky',
    'tnid',
    'translate',
  ])
  ->values([
    'nid' => '23',
    'vid' => '2004',
    'type' => 'article',
    'language' => 'en',
    'title' => 'Test article',
    'uid' => '1',
    'status' => '1',
    'created' => '1571332634',
    'changed' => '1571332634',
    'comment' => '0',
    'promote' => '1',
    'moderate' => '0',
    'sticky' => '0',
    'tnid' => '0',
    'translate' => '0',
  ])
  ->execute();

$connection->insert('node_revisions')
  ->fields([
    'nid',
    'vid',
    'uid',
    'title',
    'body',
    'teaser',
    'log',
    'timestamp',
    'format',
  ])
  ->values([
    'nid' => '23',
    'vid' => '2004',
    'uid' => '1',
    'title' => 'Test article',
    'body' => 'Some sample text.',
    'teaser' => 'Some sample text.',
    'log' => '',
    'timestamp' => '1571332634',
    'format' => '1',
  ])
  ->execute();

$connection->schema()->createTable('nodewords', [
  'fields' => [
    'mtid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'type' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => "''",
    ],
    'content' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ],
  ],
  'primary key' => [
    'mtid',
  ],
  'unique keys' => [
    'nodewords_type_id_name' => [
      'type',
      'id',
      'name',
    ],
  ],
  'indexes' => [
    'nodewords_name' => [
      [
        'name',
        '6',
      ],
    ],
    'nodewords_type_id' => [
      'type',
      'id',
    ],
  ],
  'mysql_character_set' => 'utf8',
]);

$connection->insert('nodewords')
  ->fields([
    'mtid',
    'type',
    'id',
    'name',
    'content',
  ])

  // Values for node nid 23.
  ->values([
    'mtid' => '1',
    'type' => '5',
    'id' => '23',
    'name' => 'page_title',
    'content' => 'a:3:{s:5:"value";s:10:"Test title";s:6:"append";i:1;s:7:"divider";s:3:" | ";}',
  ])
  ->values([
    'mtid' => '2',
    'type' => '5',
    'id' => '23',
    'name' => 'description',
    'content' => 'a:1:{s:5:"value";s:16:"Test description";}',
  ])
  ->values([
    'mtid' => '3',
    'type' => '5',
    'id' => '23',
    'name' => 'author',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '4',
    'type' => '5',
    'id' => '23',
    'name' => 'abstract',
    'content' => 'a:1:{s:5:"value";s:13:"Test abstract";}',
  ])
  ->values([
    'mtid' => '5',
    'type' => '5',
    'id' => '23',
    'name' => 'keywords',
    'content' => 'a:1:{s:5:"value";s:20:"Keyword 1, keyword 2";}',
  ])
  ->values([
    'mtid' => '6',
    'type' => '5',
    'id' => '23',
    'name' => 'rights',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '7',
    'type' => '5',
    'id' => '23',
    'name' => 'canonical',
    'content' => 'a:2:{s:5:"value";s:8:"this/url";s:4:"hide";i:0;}',
  ])
  ->values([
    'mtid' => '8',
    'type' => '5',
    'id' => '23',
    'name' => 'revisit-after',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '9',
    'type' => '5',
    'id' => '23',
    'name' => 'standout',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '10',
    'type' => '5',
    'id' => '23',
    'name' => 'original-source',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '11',
    'type' => '5',
    'id' => '23',
    'name' => 'robots',
    'content' => 'a:2:{s:5:"value";a:8:{s:8:"nofollow";s:8:"nofollow";s:9:"nosnippet";s:9:"nosnippet";s:5:"index";i:0;s:7:"noindex";i:0;s:6:"follow";i:0;s:9:"noarchive";i:0;s:5:"noodp";i:0;s:6:"noydir";i:0;}s:11:"use_default";i:0;}',
  ])

  // Values for taxonomy term tid 16.
  ->values([
    'mtid' => '12',
    'type' => '6',
    'id' => '16',
    'name' => 'keywords',
    'content' => 'a:1:{s:5:"value";s:16:"a taxonomy, term";}',
  ])
  ->values([
    'mtid' => '13',
    'type' => '6',
    'id' => '16',
    'name' => 'canonical',
    'content' => 'a:2:{s:5:"value";s:8:"the-term";s:4:"hide";i:0;}',
  ])

  // Values for user uid 2.
  ->values([
    'mtid' => '14',
    'type' => '8',
    'id' => '2',
    'name' => 'abstract',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '15',
    'type' => '8',
    'id' => '2',
    'name' => 'canonical',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '16',
    'type' => '8',
    'id' => '2',
    'name' => 'copyright',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '17',
    'type' => '8',
    'id' => '2',
    'name' => 'description',
    'content' => 'a:1:{s:5:"value";s:0:"";}',
  ])
  ->values([
    'mtid' => '18',
    'type' => '8',
    'id' => '2',
    'name' => 'keywords',
    'content' => 'a:1:{s:5:"value";s:0:"";}v',
  ])
  ->values([
    'mtid' => '19',
    'type' => '8',
    'id' => '2',
    'name' => 'revisit-after',
    'content' => 'a:1:{s:5:"value";s:1:"1";}',
  ])
  ->values([
    'mtid' => '20',
    'type' => '8',
    'id' => '2',
    'name' => 'robots',
    'content' => 'a:2:{s:5:"value";a:6:{s:9:"noarchive";i:0;s:8:"nofollow";i:0;s:7:"noindex";i:0;s:5:"noodp";i:0;s:9:"nosnippet";i:0;s:6:"noydir";i:0;}s:11:"use_default";i:0;}',
  ])
  ->execute();

$connection->schema()->createTable('nodewords_custom', [
  'fields' => [
    'pid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => "''",
    ],
    'path' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ],
    'enabled' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '1',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'pid',
  ],
  'mysql_character_set' => 'utf8',
]);

// @todo system table record.
$connection->insert('system')
->fields([
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'throttle',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
])
->values([
  'filename' => 'sites/all/modules/contrib/nodewords/nodewords.module',
  'name' => 'nodewords',
  'type' => 'module',
  'owner' => "''",
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6188',
  'weight' => '10',
  'info' => 'a:9:{s:4:"name";s:9:"Nodewords";s:11:"description";s:67:"Implement an API that other modules can use to implement meta tags.";s:7:"package";s:3:"SEO";s:4:"core";s:3:"6.x";s:10:"recommends";a:2:{i:0;s:8:"checkall";i:1;s:13:"vertical_tabs";}s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/contrib/nodewords/nodewords_basic/nodewords_basic.module',
  'name' => 'nodewords_basic',
  'type' => 'module',
  'owner' => "''",
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6116',
  'weight' => '12',
  'info' => "a:8:{s:4:\"name\";s:25:\"Nodewords basic meta tags\";s:11:\"description\";s:174:\"Add the 'abstract', 'canonical', 'description', 'keywords', 'logo', 'original-source', 'revisit-after', 'rights', 'robots' and 'standout' meta tags, and the 'title' HTML tag.\";s:12:\"dependencies\";a:1:{i:0;s:9:\"nodewords\";}s:7:\"package\";s:3:\"SEO\";s:4:\"core\";s:3:\"6.x\";s:10:\"dependents\";a:0:{}s:7:\"version\";N;s:3:\"php\";s:5:\"4.3.5\";}",
])
->values([
  'filename' => 'sites/all/modules/contrib/nodewords/nodewords_extra/nodewords_extra.module',
  'name' => 'nodewords_extra',
  'type' => 'module',
  'owner' => "''",
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:8:{s:4:\"name\";s:25:\"Nodewords extra meta tags\";s:11:\"description\";s:100:\"Add the Dublin Core, 'geo.placename', 'geo.position', 'geo.region', 'icbm' and 'shorturl' meta tags.\";s:12:\"dependencies\";a:1:{i:0;s:9:\"nodewords\";}s:7:\"package\";s:3:\"SEO\";s:4:\"core\";s:3:\"6.x\";s:10:\"dependents\";a:0:{}s:7:\"version\";N;s:3:\"php\";s:5:\"4.3.5\";}",
])
->values([
  'filename' => 'sites/all/modules/contrib/nodewords/nodewords_og/nodewords_og.module',
  'name' => 'nodewords_og',
  'type' => 'module',
  'owner' => "''",
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:30:"Nodewords Open Graph meta tags";s:11:"description";s:172:"Add the Open Graph (i.e. Facebook) meta tags. Note: the theme must be customized in order for these tags to work correctly, please see the README.txt file for full details.";s:12:"dependencies";a:2:{i:0;s:9:"nodewords";i:1;s:15:"nodewords_basic";}s:7:"package";s:3:"SEO";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
])
->execute();

// @todo term_data
$connection->insert('term_data')
  ->fields([
    'tid',
    'vid',
    'name',
    'description',
    'weight',
    'language',
    'trid',
  ])
  ->values([
    'tid' => '16',
    'vid' => '4',
    'name' => 'Test term',
    'description' => '',
    'weight' => '0',
    'language' => "''",
    'trid' => '0',
  ])
  ->execute();

$connection->insert('term_hierarchy')
->fields([
  'tid',
  'parent',
])
->values([
  'tid' => '16',
  'parent' => '0',
])
->execute();

$connection->insert('term_node')
->fields([
  'nid',
  'vid',
  'tid'
])
->values([
  'nid' => '23',
  'vid' => '2004',
  'tid' => '16',
])
->execute();
